var tutMenu = new Menu(true);
tutMenu.addItem("Basic Operation");
tutMenu.items[0].enabled = false;
tutMenu.addItem("Battle Operation");
tutMenu.addItem("Online Help");
tutMenu.items[2].enabled = false;
tutMenu.addItem("Information");
tutMenu.items[3].enabled = false;
tutMenu.addItem("Notes");
tutMenu.items[4].enabled = false;
tutMenu.addItem("Idolix System");
tutMenu.items[5].enabled = false;
tutMenu.heading = "TUTORIAL";
tutMenu.returnSelection = true;
tutMenu.doWhile = TutorialDraw;

function Tutorial(skip)
{
	if (skip == undefined)
	{
		//Message(17, 17, 286, "WIP", "This is the Tutorial feature that will be in the real game. For now, you can just look at it so you know what you are doing in the demo.", 0, false);
	}
	DrawBG();
	tutMenu.executeAlone(20, 54, 100, 6);
	switch (tutMenu.selection)
	{
		case -1:
			DrawBG();
			Message(17, 17, 286, "WIP", "Come on back now, you hear?", 0, false);
			break;
		default:
			topicMenu.selection = 0;
			Topics(tutMenu.selection);
			break;
	}
}

var topicMenu = new Menu(true);
topicMenu.doWhile = TopicDraw;
topicMenu.heading = "TOPIC";

function Topics(topic)
{
	topicMenu.items = new Array();
	switch (topic)
	{
		case 0:
			break;
		case 1:
			topicMenu.addItem("TIME Gauges", TopicScreen);
			topicMenu.items[0].pages = 2;
			topicMenu.items[0].screen = BattleOperationTIMEGauges;
			break;
	}
	TopicDraw();
	topicMenu.executeAlone(140, 54, 159, 10);
	if (topicMenu.selection == -1)
	{
		Tutorial(true);
	}
}

function TutorialDraw()
{
	DrawBG();
	window.drawWindow(20, 18, 66, 8, true, "MENU");
	font.drawText(25, 18, "Tutorial");
}

function TopicDraw()
{
	tutMenu.draw(20, 54, 100, 6, "Away");
}

function TopicScreen()
{
	var page = 0;
	var screenOpen = true;
	while (screenOpen)
	{
		TutorialDraw();
		window.drawWindow(20, 54, 280, 166, true, "TOPIC");
		topicMenu.items[topicMenu.selection].screen(page);
		FlipScreen();
		if (LastPush())
		{
			if (IsKeyPressed(Game.cancel))
			{
				KeyPressed(false);
				screenOpen = false;
			}
			if (IsKeyPressed(KEY_RIGHT))
			{
				KeyPressed();
				page ++;
				if (page > topicMenu.items[topicMenu.selection].pages - 1)
				{
					page = 0;
				}
			}
			if (IsKeyPressed(KEY_LEFT))
			{
				KeyPressed();
				page --;
				if (page < 0)
				{
					page = topicMenu.items[topicMenu.selection].pages - 1;
				}
			}
		}
	}
	Topics(tutMenu.selection);
}

// Following are the tutorial topics and screens
function BattleOperationTIMEGauges(page)
{
	font.drawText(20, 54, "Just testing");
	font.drawText(20, 67, page, "left", Colors.Cyan);
	return;
}